var CONTACT_RELATED_ID_PREFIX_SUGGESTION = "ymail_contactRelated";
var CONTACT_RELATED_PLACEHOLDER_TITLE = "#CONTACTITLE#";
var CONTACT_RELATED_PLACEHOLDER_SUBTITLE = "#CONTACTSUBTITLE#";
var CONTACT_RELATED_TEMPLATE_SUGGESTION =
    "<span class=\"left related-profile-image\"></span>" +
    "<span class=\"center prevent-text-selection related-name\">" +
    "   <span class=\"prevent-text-selection related-title\">" + CONTACT_RELATED_PLACEHOLDER_TITLE + "</span>" +
    "   <br/>" +
    "   <span class=\"prevent-text-selection related-subtitle\">" + CONTACT_RELATED_PLACEHOLDER_SUBTITLE + "</span>" +
    "</span>";

var contactRelatedController = {
    managers: [],
    isSearchModeOn: false,

    create: function(recipientInputNode, containerNode, parentContainerNode, uniqueTag) {
        if (!this.managers[uniqueTag]) {
            this.managers[uniqueTag] = new ContactRelatedManager(recipientInputNode, containerNode, parentContainerNode, uniqueTag);
        }
    },

    showResults: function(resultsArrayJsonString, uniqueTag, perfEvent, header) {
        this.managers[uniqueTag].showResults(resultsArrayJsonString, header);
        yMailBridge.stopAutoCompleteTimer(perfEvent);
    },

    close: function(srcInput) {
        for (const m of this.managers) {
            if (m != null && m.containerNode != null && m.isShowing()) {
                if (m.containerNode.id != srcInput) {
                    m.destroySearchMode();
                }
            }
        }
    }
};

function ContactRelatedManager(recipientInputNode, containerNode, parentContainerNode, uniqueTag) {
    this.recipientInputNode = recipientInputNode;
    this.containerNode = containerNode;
    this.parentContainerNode = parentContainerNode;
    this.areLozengesCollapsed = false;
    this.uniqueTag = uniqueTag;
    this.recipientInputNode.addEventListener("input", this.handleInput.bind(this), false);
    this.isSearchModeOn = false;
}

ContactRelatedManager.prototype.handleInput = function(event) {
    this.destroySearchMode();
};

ContactRelatedManager.prototype.handleSuggestionClick = function(event) {
    var suggestionNode = event.currentTarget;
    var email = suggestionNode.id.replace(CONTACT_RELATED_ID_PREFIX_SUGGESTION, "");
    yMailBridge.addSuggestionToRecipientField(email, this.uniqueTag, PICK_SRC_RELATED);
    this.recipientInputNode.value = "";
    this.recipientInputNode.focus();
    this.destroySearchMode();
};

ContactRelatedManager.prototype.handleCloseClick = function(event) {
    this.recipientInputNode.focus();
    this.destroySearchMode();
    yMailBridge.relatedPanelClosed();
};

ContactRelatedManager.prototype.setupSearchMode = function() {
    contactRelatedController.isSearchModeOn = true;
    this.containerNode.classList.remove("hidden");
    this.containerNode.setAttribute("aria-expanded", "true");
    this.parentContainerNode.classList.remove("underlined");
};

ContactRelatedManager.prototype.destroySearchMode = function() {
    contactRelatedController.isSearchModeOn = false;
    this.containerNode.classList.add("hidden");
    this.containerNode.setAttribute("aria-expanded", "false");
    this.parentContainerNode.classList.add("underlined");
    if (this.areLozengesCollapsed) {
        this.areLozengesCollapsed = false;
        lozengeController.expandLozenges(this.uniqueTag);
    }
    yMailBridge.setSearchModeOff(this.recipientInputNode.value);
};

ContactRelatedManager.prototype.isShowing = function() {
    var isHidden = this.containerNode.classList.contains("hidden");
    return !isHidden;
}

/**
 * Clears all the suggestions in the suggestions container node by remove all children
 */
ContactRelatedManager.prototype.clearSuggestions = function() {
    // We need to retain the existence of the hidden class
    // If we don't do this, we may end up removing the hidden class at the end of this function
    var isHidden = this.containerNode.classList.contains("hidden");

    if (!isHidden) {
         this.containerNode.classList.add("hidden");
    }

    // Clear previous results
    while (this.containerNode.firstChild) {
        this.containerNode.removeChild(this.containerNode.firstChild);
    }

    if (!isHidden) {
        this.containerNode.classList.remove("hidden");
    }
};

ContactRelatedManager.prototype.showResults = function(resultsArrayJsonString, header) {
    var resultsArray,
        result,
        suggestionNode,
        i;

    if (resultsArrayJsonString) {
        try {
            resultsArray = JSON.parse(resultsArrayJsonString);
        } catch (err) {
            log.e(err);
        }

        this.clearSuggestions();

        if (resultsArray && resultsArray.length > 0) {
            this.setupSearchMode();
            var headerNode = document.createElement("div");
            headerNode.setAttribute("id", "related");
            headerNode.setAttribute("class", "related-header-container");
            headerNode.innerHTML = "<span role='option' class=\"center prevent-text-selection related-header leftMargined\">" +
                                           "   <span class=\"prevent-text-selection related-title\">"+header+"</span>" +
                                               "<img src='./images/close.svg' aria-label='Close' role='button' class='close-img right'/>" +
                                           "</span>";
            headerNode.addEventListener("click", this.handleCloseClick.bind(this), false);
            this.containerNode.appendChild(headerNode);
            for (i = 0; i < resultsArray.length; i++) {
                result = resultsArray[i];
                suggestionNode = document.createElement("div");
                suggestionNode.setAttribute("role", "option");
                var title = decodeURIComponent(result.name);
                var subtitle = result.email;
                suggestionNode.setAttribute("id", utils.escapeHtml(CONTACT_RELATED_ID_PREFIX_SUGGESTION + subtitle));
                suggestionNode.setAttribute("aria-label", utils.escapeHtml(title + ". " + subtitle));
                suggestionNode.setAttribute("class", "related-suggestion");
                suggestionNode.innerHTML = CONTACT_RELATED_TEMPLATE_SUGGESTION
                    .replace(CONTACT_RELATED_PLACEHOLDER_TITLE, utils.escapeHtml(title))
                    .replace(CONTACT_RELATED_PLACEHOLDER_SUBTITLE, utils.escapeHtml(subtitle));

                var imageNode = suggestionNode.getElementsByClassName("related-profile-image")[0]
                imageNode.classList.add("circle-image");
                imageNode.classList.add("leftMargined");
                profileImageController.load(result.image, imageNode, result.defaultImage);
                suggestionNode.addEventListener("click", this.handleSuggestionClick.bind(this), false);
                this.containerNode.appendChild(suggestionNode);
            }
        }
    }

    if (!resultsArray || resultsArray.length === 0) {
        this.destroySearchMode();
    }
};
